| package |
package := Package name: 'Pst-GEOS-Base'.
package paxVersion: 0;
	basicComment: 'Pocket Smalltalk 1.6
Copyright (c) 1998-2001 www.PocketSmalltalk.com
GEOS changes and enhancements: Copyright (c) 1999, 2000 by Petr Novak
Toolbar enhancements: Copyright (c) 2000 by Joey Gibson (joeyGibson@mindspring.com)

This product is Open Source - see LICENSE.TXT for more information.
Home page: http://www.pocketsmalltalk.com
GEOS version home page: http://www.i.cz/PeN/pst9110.html
SE version: http://www.joeygibson.com/st

After filing in this package, evaluate the following to open a launcher (you can replace initSystem
with initGeosSystem or initPalmOSSystem):

	Pst initGeosSystem.
	PstLauncher show.'.

package basicPackageVersion: ''.

"Add the package scripts"

"Add the class names, loose method names, global names, resource names"
package classNames
	add: #PstGeosAPI;
	add: #PstGeosCodeGenerator;
	add: #PstGeosLibCall;
	add: #PstGeosMessageInstruction;
	add: #PstGeosVMFile;
	add: #PstGeosVMFileBlock;
	add: #PstPocketSmalltalkGEOS;
	yourself.

package methodNames
	add: #PstConstantsLibrary -> #geosLibraries;
	add: #PstConstantsLibrary -> #nextGeosLibraryConstantName;
	add: 'Pst class' -> #initGeosSystem;
	yourself.

package globalNames
	yourself.

package resourceNames
	yourself.

"Binary Global Names"
package binaryGlobalNames: (Set new
	yourself).
"Resource Names"
package allResourceNames: (Set new
	yourself).

"Add the prerequisite names"
package setPrerequisites: (IdentitySet new
	add: 'Dolphin';
	add: 'Pst-Base';
	yourself).

package!

"Class Definitions"!

Pst subclass: #PstGeosVMFile
	instanceVariableNames: 'defaultFilename blocks name token application'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Pst subclass: #PstGeosVMFileBlock
	instanceVariableNames: 'contents id'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkCodeGenerator subclass: #PstGeosCodeGenerator
	instanceVariableNames: 'geosVM fileStream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSysTrapInstruction subclass: #PstGeosMessageInstruction
	instanceVariableNames: 'arguments'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstOSAPI subclass: #PstGeosAPI
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstOSTrap subclass: #PstGeosLibCall
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkSystem subclass: #PstPocketSmalltalkGEOS
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
"Loose Methods"!

!Pst class methodsFor!

initGeosSystem

	self initUsingSystemClass: PstPocketSmalltalkGEOS.! !
!Pst class categoriesFor: #initGeosSystem!initialization!public! !

!PstConstantsLibrary methodsFor!

geosLibraries
	| libraries constantName constant |
	libraries := OrderedCollection new.
	0 to: 127 do: [ :index |
	 constantName := 'geosLIB', index printString.
	 (self hasConstantNamed: constantName)
		ifTrue: [
		 constant := self constantNamed: constantName.
		 constant value qclass name = 'String' 
			ifTrue: [libraries add: ((String with: (Character value: index)), constant value convertToString)]
			ifFalse: [PstCrossPlatformInterface notify: 
				'Constant ##', constantName, ' is not a string.']].
	].
	^libraries!

nextGeosLibraryConstantName
	"Answer a constant name for a new geosLibrary constant.  Does not actually create the constant."
	| n name |
	n := 1.
	[name := 'geosLIB', n printString.
	 (self hasConstantNamed: name) ifFalse: [^name].
	 n := n + 1] repeat.! !
!PstConstantsLibrary categoriesFor: #geosLibraries!*-unclassified!public! !
!PstConstantsLibrary categoriesFor: #nextGeosLibraryConstantName!*-unclassified!public! !

"End of package definition"!



PstGeosVMFile comment: ''!

PstGeosVMFile guid: (GUID fromString: '{4C99E910-0F88-481C-AEB1-54EB8A7F1BAB}')!

!PstGeosVMFile categoriesForClass!No category! !
!PstGeosVMFile methodsFor!

add: data withID: anID
	blocks add: (PstGeosVMFileBlock data: data withID: anID).!

application
	^ application.!

application: string
	application := string.!

defaultFilename
	^defaultFilename.
!

defaultFilename: string
	defaultFilename := string.
!

dirsize
	^32 + ((blocks size +1) * 12).
!

initialize
	super initialize.
	blocks := OrderedCollection new.
	name := self class defaultTitle.
	token := self class defaultToken.
	application := self class defaultApplication.!

name
	^name.!

name: string
	name := string.!

nexthdl
	^self dirsize.!

save
	self assert: [defaultFilename notNil].
	self writeToFileNamed: defaultFilename.
!

token
	^ token.!

token: string
	token := string.!

totalsize
	| result |
	result := self dirsize.
	blocks do: [:block |
		result := result + block size + 2.
	].
	^result.!

writeGeosHeaderOn: stream
	| qsc |
	"GEOS file header, version 2"
	qsc := PstSystem current.

	"GEOS 2 ID"
	qsc storeLongword: 16r53C145C7 on: stream.

	"name of file"
	self writeNameOn: stream.

	qsc
		"class" storeWord: 2 on: stream;
		"flags" storeWord: 0 on: stream;
		"version" storeLongword: 0 on: stream;
		"revision" storeLongword: 0 on: stream;
		"protocol" storeLongword: 0 on: stream.

	"token"
	stream nextPutAll: token asByteArray.

	qsc storeWord: 0 on: stream.
	"application"
	stream nextPutAll: application asByteArray.

	qsc storeWord: 0 on: stream.

	"info"
	stream next: 100 put: 0.
	"copyright"
	stream next: 32 put: 0.
	"date, time"
	qsc storeLongword: 0 on: stream.
	"password, unused"
	stream next: (8+44) put: 0.
	self assert: [ stream position = 16r100 ].!

writeHeaderOn: stream
	"GEOS file header, version 2"
	self writeGeosHeaderOn: stream.

	"VM File Header, version 2"
	self writeVMFileHeaderOn: stream.

	"junk?"
	stream next: 16 put: 0.
	self assert: [stream position = 16r118].

	"VM directory"
	self writeVMDirectoryOn: stream.!

writeNameOn: stream
	stream 
		nextPutAll: self name asByteArray;
		next: 36 - self name size put: 0.
!

writeOn: stream
	| headerStream bodyStream offset |
	headerStream := ByteArray new writeStream.
	self writeHeaderOn: headerStream.
	bodyStream := ByteArray new writeStream.
	blocks do: [:block |
		PstSystem current storeWord: block size on: bodyStream.
		bodyStream nextPutAll: block contents].
	stream
		nextPutAll: headerStream contents;
		nextPutAll: bodyStream contents.!

writeToFileNamed: filename
	| stream |
	stream := PstCrossPlatformInterface openReadOnly: false fileNamed: filename asText: false.
	[self writeOn: stream]
		ensure: [stream close].
!

writeVMDirectoryOn: stream
	| qsc |

	"VM directory"
	(qsc := PstSystem current)
		"IDvmfdir"
		storeWord: 16r00FB on: stream;
		"hdl_1stfree"
		storeWord: 0 on: stream;
		"hdl_lastfree"
		storeWord: 0 on: stream;
		"hdl_1stunused"
		storeWord: self nexthdl on: stream;
		"dirsize"
		storeWord: self dirsize on: stream;
		"nblocks_free"
		storeWord: 0 on: stream;
		"nhdls_free"
		storeWord: 0 on: stream;
		"nblocks_used"
		storeWord: blocks size + 1 on: stream;
		"nblocks_loaded"
		storeWord: 0 on: stream;
		"x2"
		storeWord: 0 on: stream;
		"hdl_first"
		storeWord: 16r2C on: stream;
		"x2b"
		storeWord: 0 on: stream;
		"totalsize"
		storeLongword: self totalsize on: stream;
		"flags"
		storeWord: 0 on: stream;
		"hdl_dbmap"
		storeWord: 0 on: stream.
	self assert: [ stream position = 16r138 ].

	"handle table"
	"DIR block"
	qsc
		"handle"
		storeWord: 0 on: stream;
		"flags"
		storeWord: 16rFF on: stream;
		"ID"
		storeWord: 0 on: stream;
		"blocksize"
		storeWord: self dirsize on: stream;
		"blockptr"
		storeLongword: 16r18 on: stream.

	"data blocks"
	blocks inject: 16r18 + self dirsize into: [:pos :block |
		qsc
			"handle"
			storeWord: 0 on: stream;
			"flags"
			storeWord: 16rFF on: stream;
			"ID"
			storeWord: block id on: stream;
			"blocksize"
			storeWord: (block size + 2) on: stream;
			"blockptr"
			storeLongword: pos on: stream.
		pos + block size + 2.
	].
	self assert: [ stream position = (16r118 + self dirsize) ].!

writeVMFileHeaderOn: stream
	"VM File Header, version 2"
	PstSystem current
		"IDVM"
		storeWord: 16rADEB on: stream;
		"dirsize"
		storeWord: self dirsize on: stream;
		"dirptr"
		storeLongword: 16r18 on: stream.
	self assert: [ stream position = 16r108 ].! !
!PstGeosVMFile categoriesFor: #add:withID:!accessing!public! !
!PstGeosVMFile categoriesFor: #application!accessing!public! !
!PstGeosVMFile categoriesFor: #application:!accessing!public! !
!PstGeosVMFile categoriesFor: #defaultFilename!accessing!public! !
!PstGeosVMFile categoriesFor: #defaultFilename:!accessing!public! !
!PstGeosVMFile categoriesFor: #dirsize!accessing!public! !
!PstGeosVMFile categoriesFor: #initialize!initialization!public! !
!PstGeosVMFile categoriesFor: #name!accessing!public! !
!PstGeosVMFile categoriesFor: #name:!accessing!public! !
!PstGeosVMFile categoriesFor: #nexthdl!accessing!public! !
!PstGeosVMFile categoriesFor: #save!public!writing! !
!PstGeosVMFile categoriesFor: #token!accessing!public! !
!PstGeosVMFile categoriesFor: #token:!accessing!public! !
!PstGeosVMFile categoriesFor: #totalsize!accessing!public! !
!PstGeosVMFile categoriesFor: #writeGeosHeaderOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeHeaderOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeNameOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeToFileNamed:!public!writing! !
!PstGeosVMFile categoriesFor: #writeVMDirectoryOn:!public!writing! !
!PstGeosVMFile categoriesFor: #writeVMFileHeaderOn:!public!writing! !

!PstGeosVMFile class methodsFor!

defaultApplication
	^'PKST'.!

defaultName
	^'pstvm.vm'.!

defaultTitle
	^'pstvm.vm'.!

defaultToken
	^'PKST'.! !
!PstGeosVMFile class categoriesFor: #defaultApplication!*-unclassified!public! !
!PstGeosVMFile class categoriesFor: #defaultName!*-unclassified!public! !
!PstGeosVMFile class categoriesFor: #defaultTitle!*-unclassified!public! !
!PstGeosVMFile class categoriesFor: #defaultToken!*-unclassified!public! !



PstGeosVMFileBlock comment: ''!

PstGeosVMFileBlock guid: (GUID fromString: '{C0A7D594-8646-4620-9974-1F56B4C83B9A}')!

!PstGeosVMFileBlock categoriesForClass!No category! !
!PstGeosVMFileBlock methodsFor!

contents
	^contents

!

data: data
	contents := data.
	^self!

data: data withID: myId
	contents := data.
	id := myId.
	^self!

id
	^id
!

id: myId
	id := myId.
	^self



!

size
	^contents size


! !
!PstGeosVMFileBlock categoriesFor: #contents!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #data:!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #data:withID:!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #id!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #id:!*-unclassified!public! !
!PstGeosVMFileBlock categoriesFor: #size!*-unclassified!public! !

!PstGeosVMFileBlock class methodsFor!

data: data withID: id
	| block |
	block := self new.
	^block data: data withID: id.! !
!PstGeosVMFileBlock class categoriesFor: #data:withID:!*-unclassified!public! !



PstGeosCodeGenerator comment: ''!

PstGeosCodeGenerator guid: (GUID fromString: '{DFA7BCDB-CD22-4764-9723-E9141AB89796}')!

!PstGeosCodeGenerator categoriesForClass!No category! !
!PstGeosCodeGenerator methodsFor!

addLibraries
         | libname |
	PstConstantsLibrary current geosLibraries do: [:lib |
                 libname := WriteStream on: String new.
                 libname nextPutAll: lib.
                 libname nextPut: Character null.
		geosVM add: libname contents asByteArray withID: 7].!

fileStream: stream
	fileStream := stream.
!

writeClassNameData
	geosVM add: classNameData contents withID: 5.!

writeClassOffsets
	| stream |
	stream := ByteArray new writeStream.
	classOffsets do: [:each |
		PstSystem current storeWord: each on: stream].
	geosVM add: stream contents withID: 3.!

writeClassSegments
	classSegments keysAndValuesDo: [:index :each |
		geosVM add: each withID: 2].!

writeHeader
	"don't really need to do anything."
!

writeImageFile
	geosVM := PstGeosVMFile new initialize.
"	geosVM
		creatorID: self databaseCreatorID;
		title: self databaseTitle.
"
        self addLibraries.
	super writeImageFile.
	geosVM writeOn: fileStream.!

writeObjectSegments
	objectSegments keysAndValuesDo: [:index :each |
		geosVM add: each withID: 1].!

writeProperties
	geosVM add: self properties asResource contents withID: 6.!

writeSelectorData
	| data |
	selectorDataSegments add: selectorData contents.
	selectorDataSegments keysAndValuesDo: [:index :each |
		geosVM add: each withID: 4].! !
!PstGeosCodeGenerator categoriesFor: #addLibraries!*-unclassified!public! !
!PstGeosCodeGenerator categoriesFor: #fileStream:!initialization!public! !
!PstGeosCodeGenerator categoriesFor: #writeClassNameData!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeClassOffsets!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeClassSegments!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeHeader!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeImageFile!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeObjectSegments!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeProperties!platform specific!public! !
!PstGeosCodeGenerator categoriesFor: #writeSelectorData!platform specific!public! !

!PstGeosCodeGenerator class methodsFor!

on: stream
	^self new fileStream: stream.
! !
!PstGeosCodeGenerator class categoriesFor: #on:!instance creation!public! !



PstGeosMessageInstruction comment: ''!

PstGeosMessageInstruction guid: (GUID fromString: '{ED379CE7-C812-492B-89A2-B50BFADA9E45}')!

!PstGeosMessageInstruction categoriesForClass!No category! !
!PstGeosMessageInstruction methodsFor!

arguments
	^ arguments!

arguments: nargs
	arguments := nargs!

description
	| qualifier |
	qualifier := ignoreReturn
		ifTrue: [', ignore return value']
		ifFalse: [''].
	^'GEOS ', trapName displayString, ', ', arguments displayString, ' arguments', qualifier.!

generateCodeFor: generator
	trapName = 'call'
		ifTrue: [
			code := ignoreReturn
				ifTrue: [#[16rFD]] ifFalse: [#[16rFC]]
		]
		ifFalse: [
			code := ignoreReturn
				ifTrue: [#[16rFB]] ifFalse: [#[16rFA]]
		].
	code := code, (ByteArray with: arguments).
	"code := code, self trap bytecodes."!

trap
	^PstGeosAPI messageNamed: trapName.
! !
!PstGeosMessageInstruction categoriesFor: #arguments!*-unclassified!public! !
!PstGeosMessageInstruction categoriesFor: #arguments:!*-unclassified!public! !
!PstGeosMessageInstruction categoriesFor: #description!*-unclassified!public! !
!PstGeosMessageInstruction categoriesFor: #generateCodeFor:!*-unclassified!public! !
!PstGeosMessageInstruction categoriesFor: #trap!*-unclassified!public! !



PstGeosAPI comment: ''!

PstGeosAPI guid: (GUID fromString: '{7A91881B-38B3-4FEA-8F13-63D1AF820E0D}')!

!PstGeosAPI categoriesForClass!No category! !


PstGeosLibCall comment: ''!

PstGeosLibCall guid: (GUID fromString: '{B943B85C-BCA4-46BD-A1F0-E6F5F9015679}')!

!PstGeosLibCall categoriesForClass!No category! !
!PstGeosLibCall methodsFor!

bytecodes
	"Answer the bytecodes, not including the initial opcode."
	| stream |
	stream := ByteArray new writeStream.
	stream
		nextPut: ((functionNumber bitShift: -16) bitAnd: 16rFF);
                nextPut: ((functionNumber bitShift: -8) bitAnd: 16rFF);
		nextPut: (functionNumber bitAnd: 16rFF);
		nextPut: self argumentCount.
	argumentTypes do: [:type |
		stream nextPut: (self specForType: type)].
	stream nextPut: (self specForType: returnType).
	^stream contents.!

name: trapName
functionNumber: number
argumentTypes: argTypes
returnType: retType
	name := trapName.
	functionNumber := number.
	argumentTypes := argTypes.
	returnType := retType.! !
!PstGeosLibCall categoriesFor: #bytecodes!*-unclassified!public! !
!PstGeosLibCall categoriesFor: #name:functionNumber:argumentTypes:returnType:!*-unclassified!public! !



PstPocketSmalltalkGEOS comment: ''!

PstPocketSmalltalkGEOS guid: (GUID fromString: '{EC7A0949-12D4-4287-AF8F-96897BB0AD7B}')!

!PstPocketSmalltalkGEOS categoriesForClass!No category! !
!PstPocketSmalltalkGEOS methodsFor!

apiClass
	^PstGeosAPI!

codeGeneratorClass
	^PstGeosCodeGenerator.!

compileSendOn: compiler pop: pop forMessageNode: messageNode

	| messageName |
	messageName := messageNode keywords first copyWithout: $:.
"
	(PstGeosAPI hasMessageNamed: messageName) ifFalse: [
		^compiler
			error: 'No such geosMessage'
			for: messageNode].
	(messageNode arguments size =
			(PstGeosAPI messageNamed: messageName) argumentCount)
		ifFalse: [
			^compiler
				error: 'Wrong number of arguments to geosMessage'
				for: messageNode].
"
	messageNode compileArgumentsOn: compiler.
	compiler emit: (PstGeosMessageInstruction new
		trapName: messageName;
		ignoreReturn: pop;
		arguments: messageNode arguments size).!

doubleByteOrder
	^#[1 2 3 4 5 6 7 8]!

osCallKeyword
	"	^	<String>
	Return the keyword that identifies an OS call in me."

	^'GEOS'!

storeLongword: value on: stream
	"Little endian"
	self
		storeWord: (value bitAnd: 16rFFFF)
		on: stream.
	self
		storeWord: (value bitShift: -16)
		on: stream.!

storeWord: value on: stream
	"Little endian"
	stream
		nextPut: (value bitAnd: 16rFF);
		nextPut: ((value bitShift: -8) bitAnd: 16rFF).!

trapClass
	^PstGeosLibCall
! !
!PstPocketSmalltalkGEOS categoriesFor: #apiClass!*-unclassified!public! !
!PstPocketSmalltalkGEOS categoriesFor: #codeGeneratorClass!parameters!public! !
!PstPocketSmalltalkGEOS categoriesFor: #compileSendOn:pop:forMessageNode:!parameters!public! !
!PstPocketSmalltalkGEOS categoriesFor: #doubleByteOrder!*-unclassified!public! !
!PstPocketSmalltalkGEOS categoriesFor: #osCallKeyword!parameters!public! !
!PstPocketSmalltalkGEOS categoriesFor: #storeLongword:on:!public!utility! !
!PstPocketSmalltalkGEOS categoriesFor: #storeWord:on:!public!utility! !
!PstPocketSmalltalkGEOS categoriesFor: #trapClass!parameters!public! !

!PstPocketSmalltalkGEOS class methodsFor!

displayName
	"	^	<String>
	Return a descriptive string of me."

	^'GEOS'!

systemFilesPath
	"	^	<String>
	Return the path to the system files needed to build a GEOS application.
	Files such as the base.st and vm executable.
	NOTE: The resulting path should NOT have the final '\' path delimeter."

	^'geos'!

systemFilesToLoad
	"
	Answer a collection of file names that should be loaded into a new project."

	^#(
		'pstcore.st'
		'enums.st'
		'structs.st'
		'gcore.st'
		'geos.st' 
		'ansic.st'
		'eci.st'
		'ui.st'
		'color.st'
		'ruler.st'
		'styles.st'
		'text.st'
		'foam.st'
		'ghelpers.st'
		)! !
!PstPocketSmalltalkGEOS class categoriesFor: #displayName!*-unclassified!public! !
!PstPocketSmalltalkGEOS class categoriesFor: #systemFilesPath!*-unclassified!public! !
!PstPocketSmalltalkGEOS class categoriesFor: #systemFilesToLoad!*-unclassified!public! !

 
"Binary Globals"!

"Resources"!

